/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.sequence;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.data.DataHolder;
import icyllis.flexmark.util.data.DataKeyBase;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.BasedSequenceImpl;
import icyllis.flexmark.util.sequence.Range;
import icyllis.flexmark.util.sequence.RepeatedSequence;
import icyllis.flexmark.util.sequence.ReplacedBasedSequence;
import icyllis.flexmark.util.sequence.SequenceUtils;
import icyllis.flexmark.util.sequence.builder.IBasedSegmentBuilder;

public final class PrefixedSubSequence
extends BasedSequenceImpl
implements ReplacedBasedSequence {
    private final CharSequence prefix;
    private final BasedSequence base;

    private PrefixedSubSequence(CharSequence prefix, BasedSequence baseSeq, int startIndex, int endIndex) {
        super(0);
        this.prefix = prefix;
        this.base = baseSeq.subSequence(startIndex, endIndex);
    }

    @Override
    @NotNull
    public Object getBase() {
        return this.base.getBase();
    }

    @Override
    @NotNull
    public BasedSequence getBaseSequence() {
        return this.base.getBaseSequence();
    }

    @Override
    public int getStartOffset() {
        return this.base.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.base.getEndOffset();
    }

    @Override
    @NotNull
    public Range getSourceRange() {
        return this.base.getSourceRange();
    }

    @Override
    @NotNull
    public BasedSequence baseSubSequence(int startIndex, int endIndex) {
        return this.base.baseSubSequence(startIndex, endIndex);
    }

    @Override
    public int getOptionFlags() {
        return this.getBaseSequence().getOptionFlags();
    }

    @Override
    public boolean allOptions(int options) {
        return this.getBaseSequence().allOptions(options);
    }

    @Override
    public boolean anyOptions(int options) {
        return this.getBaseSequence().anyOptions(options);
    }

    @Override
    public <T> T getOption(DataKeyBase<T> dataKey) {
        return this.getBaseSequence().getOption(dataKey);
    }

    @Override
    @Nullable
    public DataHolder getOptions() {
        return this.getBaseSequence().getOptions();
    }

    @Override
    public int length() {
        return this.prefix.length() + this.base.length();
    }

    @Override
    public int getIndexOffset(int index) {
        SequenceUtils.validateIndexInclusiveEnd(index, this.length());
        if (index < this.prefix.length()) {
            return -1;
        }
        return this.base.getIndexOffset(index - this.prefix.length());
    }

    @Override
    public void addSegments(@NotNull IBasedSegmentBuilder<?> builder) {
        if (this.prefix.length() != 0) {
            builder.append(this.base.getStartOffset(), this.base.getStartOffset());
            builder.append(this.prefix.toString());
        }
        this.base.addSegments(builder);
    }

    @Override
    public char charAt(int index) {
        SequenceUtils.validateIndex(index, this.length());
        int prefixLength = this.prefix.length();
        if (index < prefixLength) {
            return this.prefix.charAt(index);
        }
        return this.base.charAt(index - prefixLength);
    }

    @Override
    @NotNull
    public BasedSequence subSequence(int startIndex, int endIndex) {
        SequenceUtils.validateStartEnd(startIndex, endIndex, this.length());
        int prefixLength = this.prefix.length();
        if (startIndex < prefixLength) {
            if (endIndex <= prefixLength) {
                return new PrefixedSubSequence(this.prefix.subSequence(startIndex, endIndex), this.base.subSequence(0, 0), 0, 0);
            }
            return new PrefixedSubSequence(this.prefix.subSequence(startIndex, prefixLength), this.base, 0, endIndex - prefixLength);
        }
        return this.base.subSequence(startIndex - prefixLength, endIndex - prefixLength);
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.prefix);
        this.base.appendTo(sb);
        return sb.toString();
    }

    public static PrefixedSubSequence repeatOf(CharSequence prefix, int count, BasedSequence baseSeq) {
        return PrefixedSubSequence.prefixOf(RepeatedSequence.repeatOf(prefix, count).toString(), baseSeq, 0, baseSeq.length());
    }

    public static PrefixedSubSequence repeatOf(char prefix, int count, BasedSequence baseSeq) {
        return PrefixedSubSequence.prefixOf(RepeatedSequence.repeatOf(prefix, count), baseSeq, 0, baseSeq.length());
    }

    public static PrefixedSubSequence prefixOf(CharSequence prefix, BasedSequence baseSeq) {
        return PrefixedSubSequence.prefixOf(prefix, baseSeq, 0, baseSeq.length());
    }

    public static PrefixedSubSequence prefixOf(CharSequence prefix, BasedSequence baseSeq, int startIndex) {
        return PrefixedSubSequence.prefixOf(prefix, baseSeq, startIndex, baseSeq.length());
    }

    public static PrefixedSubSequence prefixOf(CharSequence prefix, BasedSequence baseSeq, int startIndex, int endIndex) {
        return new PrefixedSubSequence(prefix, baseSeq, startIndex, endIndex);
    }

    @Deprecated
    public static PrefixedSubSequence of(CharSequence prefix, BasedSequence baseSeq) {
        return PrefixedSubSequence.prefixOf(prefix, baseSeq);
    }

    @Deprecated
    public static PrefixedSubSequence of(CharSequence prefix, BasedSequence baseSeq, int startIndex) {
        return PrefixedSubSequence.prefixOf(prefix, baseSeq, startIndex);
    }

    @Deprecated
    public static PrefixedSubSequence of(CharSequence prefix, BasedSequence baseSeq, int startIndex, int endIndex) {
        return PrefixedSubSequence.prefixOf(prefix, baseSeq, startIndex, endIndex);
    }
}

